#include <algorithm>
#include <iostream>
#include <vector>
#include <string>
using namespace std;
typedef long long ll;
#define fi first
#define se second
#define fr front()
#define pb push_back

void print_mat(const vector<vector<int>>& mat)
{
	for (int i = 0; i < mat.size(); i++)
	{
		for (int j = 0; j < mat[i].size(); j++)
		{
			cout << mat[i][j] << " ";
		}
		cout << endl;
	}
}

bool check(const vector<vector<int>>& dp_min, const vector<vector<int>>& dp_max, int i, int j, int k)
{
	return k >= dp_min[i][j] && k <= dp_max[i][j];
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	int z;
	int test_cnt; cin >> test_cnt >> z;
	while (test_cnt--)
	{
		int n, m, k; cin >> n >> m >> k;
		vector<vector<bool>> mat(n, vector<bool>(m));
		for (int i = 0; i < n; i++)
		{
			string s; cin >> s;
			for (int j = 0; j < m; j++)
				mat[i][j] = (s[j] == '1');
		}
		vector<vector<int>> dp_min(n, vector<int>(m));
		vector<vector<int>> dp_max(n, vector<int>(m));
		dp_min[0][0] = dp_max[0][0] = mat[0][0];
		for (int i = 1; i < m; i++)
		{
			dp_min[0][i] = mat[0][i] + dp_min[0][i - 1];
			dp_max[0][i] = mat[0][i] + dp_max[0][i - 1];
		}
		
		for (int i = 1; i < n; i++)
		{
			dp_min[i][0] = mat[i][0] + dp_min[i - 1][0];
			dp_max[i][0] = mat[i][0] + dp_min[i - 1][0];
		}
		
		for (int i = 1; i < n; i++)
		{
			for (int j = 1; j < m; j++)
			{
				dp_min[i][j] = min(dp_min[i - 1][j], dp_min[i][j - 1]);
				dp_max[i][j] = max(dp_max[i - 1][j], dp_max[i][j - 1]);
				if (mat[i][j])
				{
					dp_min[i][j]++;
					dp_max[i][j]++;
				}
			}
		}

		if (k >= dp_min[n - 1][m - 1] && k <= dp_max[n - 1][m - 1])
		{
			cout << "DA\n";
			string sol;
			if (z)
			{
				int r = n - 1;
				int c = m - 1;
				while (r != 0 || c != 0)
				{
					k -= mat[r][c];
					if (r == 0)
					{
						c--;
						sol += 'D';
					}
					else if (c == 0)
					{
						r--;
						sol += 'S';
					}
					else
					{
						if (check(dp_min,dp_max,r-1,c,k))
						{
							r--;
							sol += 'S';
						}
						else if (check(dp_min,dp_max,r,c-1,k))
						{
							c--;
							sol += 'D';
						}
					}
				}
				reverse(sol.begin(), sol.end());
				cout << sol << "\n";
			}
		}
		else
		{
			cout << "NE\n";
		}
	}

	return 0;
}